%{
This m-file belongs to Chapter 4 of the dissertation 'Electrochemical CO2
conversion with a flow-through copper hollow fibre'
Anne Sustronk (1,2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figures 1, 2 and 3 in the chapter.

This file is called by Fig1.m and by Fig2And3.m.

Note that the file locations in lines 41, 70, 75, and 80 of
ConstantPotentialCO2.m should be added before execution of Fig1.m

Note that the file locations in lines 46, 73, 78 and 83 of 
ConstantPotentialCO.m should be added before execution of Fig2And3.m.

Version date m-file: March 22, 2023
%}


function [XandCI] = CalErr(X, Y, q,b0,b1,YExp)

        % Remove NaN from Y vector
        Y(isnan(Y)) = [];
        
        % Amount of data points in calibration
        n = length(X);
        
        % Calculate estimated value
        Yhat = b0+b1.*X;
        
        %% Calculate mean, error sum of squares and mean square error of calibration
        XAvg = mean(X);
        YAvg = mean(Y);
        S_XX = sum(X.^2)-length(X)*XAvg.^2;
        s_2 = sum((Y-Yhat).^2)/(n-1);
        
        %% Calculate standard deviation of X estimated from Y
        % Estimate X from Y (Inverse regression)
        XEstim = (YExp-b0)/b1;
        
        % Calculate standard deviation of the experimental value(s)
        SD = 1/b1.*sqrt(s_2.*((1./q)+(1/n)+(YExp-YAvg).^2/(b1.^2.*S_XX)));
        
        %% Display results
        
        XandCI = [XEstim' SD'];
        
    end
